/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.Diskette;
import com.ibm.hwmca.fw.mediasvc.InvalidFileSystemException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceProperties;
import com.ibm.hwmca.fw.mediasvc.MediaProperties;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameterKeys;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameters;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public abstract class MediaDevice
implements MediaServicesErrorIds,
MediaServicesParameterKeys {
    static final String TRACE_MASKT = "XMDADEVT";
    static final String TRACE_MASKF = "XMDADEVF";
    static final String TRACE_MASKD = "XMDADEVD";
    public static final int FILESYSTEM_VFAT = 1;
    public static final int FILESYSTEM_UDF = 2;
    public static final int FILESYSTEM_ISO9660 = 3;
    public static final int FILESYSTEM_EXT2 = 4;
    public static final int FILESYSTEM_EXT3 = 5;
    public static final String VFAT = "vfat";
    public static final String UDF = "udf";
    public static final String ISO9660 = "iso9660";
    public static final String EXT2 = "ext2";
    public static final String EXT3 = "ext3";
    public static final String MSDOS = "msdos";
    private static final String[] MOUNT_SCRIPT_MESSAGES = new String[]{"Successful mount in read-write mode...", "Error mounting, cause unknown...", "Could not unmount already mounted media...", "Successful mount in read-only mode...", "Error mounting, apparently due to hardware failure...", "Error mounting, media not inserted...", "Error mounting, unrecognized filesystem...possibly unformatted media", "Error attempting to mount read-only media in read-write mode..."};
    private static final String UNMOUNTSCRIPT = "media.unmount.script";
    private static final String MOUNTSCRIPT = "media.mount.script";
    private static final String WHO_AM_I_COMMAND = "whoami";
    private static final String OUTPUT_FILE_SUFFIX = "_output";
    private static final String DVD_WRITE_CHECK_FILE = "writecheck";
    private static final String DVD_WRITE_TEST_STRING = "Can we write to the dvd?";
    static final String EJECTSCRIPT = "media.eject.script";
    static final String CHECKMEDIASCRIPT = "media.device.check.media.script";
    static final String LOCKDOORCOMMAND = "media.device.lockdoor";
    static final String UNLOCKDOORCOMMAND = "media.device.unlockdoor";
    static final String LOCKSCRIPT = "media.device.lock.script";
    static final String DISKETTEFORMATSCRIPT = "media.disketteformat.script";
    static final String DVDFORMATSCRIPT = "media.dvdformat.script";
    private boolean writeProtected;
    boolean mountWithUid = false;
    boolean readOnly;
    boolean driveDoorLocked;
    boolean isMounted;
    MediaServicesParameters mediaServicesParameters;
    MediaDeviceIdentifier mediaDeviceIdentifier;
    MediaProperties mediaProperties;
    MediaDeviceProperties mediaDeviceProperties;

    MediaDevice(MediaDeviceIdentifier id) {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.MediaDevice(MediaDeviceIdentifier = " + id + ")");
        this.mediaDeviceIdentifier = id;
        this.mediaDeviceProperties = id.getMediaDeviceProperties();
        this.mediaServicesParameters = MediaServicesParameters.getMediaServicesParameters();
        this.mediaProperties = new MediaProperties(this.mediaDeviceProperties);
        this.driveDoorLocked = false;
        Trace.trace(TRACE_MASKT, "<- MediaDevice.MediaDevice()");
    }

    boolean isLockValid() {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isLockValid()");
        boolean result = false;
        result = this.mediaDeviceProperties != null;
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isLockValid(): returns " + result);
        return result;
    }

    abstract String readLabelFile(String var1) throws IOException;

    abstract boolean isMediaPresent() throws MediaDeviceLockException;

    public abstract void eject() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException;

    public abstract void format(String var1, int var2) throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, IllegalArgumentException, UnsupportedOperationException;

    public abstract String getLabel() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException;

    public boolean isDriveDoorLocked() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isDriveDoorLocked()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isDriveDoorLocked(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.mediaDeviceProperties.isLockable()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isDriveDoorLocked(): The media device is not lockable.");
            Trace.trace(TRACE_MASKT, "<- MediaDevice.isDriveDoorLocked(): returns false");
            return false;
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isDriveDoorLocked(): returns " + this.driveDoorLocked);
        return this.driveDoorLocked;
    }

    public boolean isDriveDoorLockable() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isDriveDoorLockable()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isDriveDoorLockable(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isDriveDoorLockable(): returns " + this.mediaDeviceProperties.isLockable());
        return this.mediaDeviceProperties.isLockable();
    }

    public boolean isEjectable() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isEjectable()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isEjectable(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isEjectable(): returns " + this.mediaDeviceProperties.isEjectable());
        return this.mediaDeviceProperties.isEjectable();
    }

    public boolean isFormattable() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isFormattable()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isFormattable(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isFormattable(): returns " + this.mediaDeviceProperties.isFormattable());
        return this.mediaDeviceProperties.isFormattable();
    }

    public boolean isReadOnly() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isReadOnly()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isReadOnly(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (this.mediaDeviceProperties.isReadOnly()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isReadOnly(): The media device is read only.");
            Trace.trace(TRACE_MASKT, "<- MediaDevice.isReadOnly(): returns true");
            return true;
        }
        if (!this.isMounted()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isReadOnly(): The media is not mounted.");
            throw new MediaDeviceException("cannot determine this on unmounted device");
        }
        if (this.getFileSystemType() == 3) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isReadOnly(): The media has a read only iso9660 filesystem.");
            Trace.trace(TRACE_MASKF, "MediaDevice.isReadOnly(): returns true");
            return true;
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isReadOnly(): returns " + this.writeProtected);
        return this.writeProtected;
    }

    public int getFileSystemType() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getFileSystemType()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getFileSystemType(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMounted()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getFileSystemType(): The media is not mounted.");
            throw new MediaDeviceException("cannot check file system when device not mounted");
        }
        String fileSystem = this.mediaProperties.getFileSystemType();
        Trace.trace(TRACE_MASKF, "MediaServices.getFileSystemType(): fileSystem = " + fileSystem);
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getFileSystemType()");
        if (fileSystem.equals(UDF)) {
            Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType(): fileSystem equals udf.");
            return 2;
        }
        if (fileSystem.equals(ISO9660)) {
            Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType(): fileSystem equals iso9660.");
            return 3;
        }
        if (fileSystem.equals(EXT2)) {
            Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType(): fileSystem equals ext2.");
            return 4;
        }
        if (fileSystem.equals(EXT3)) {
            Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType(): fileSystem equals ext3.");
            return 5;
        }
        if (fileSystem.equals(VFAT) || fileSystem.equals(MSDOS)) {
            if (fileSystem.equals(VFAT)) {
                Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType():  fileSystem equals vfat.");
            } else {
                Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType(): fileSystem equals msdos.");
            }
            return 1;
        }
        throw new MediaDeviceException("unknown file system");
    }

    public long getTotalSpace() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getTotalSpace()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getTotalSpace(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMounted()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getTotalSpace(): The media is not mounted.");
            throw new MediaDeviceException("cannot determine total amount of space on unmounted device");
        }
        long totalSpace = 1000L * this.mediaProperties.getTotalSpace();
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getTotalSpace(): returns " + totalSpace);
        return totalSpace;
    }

    public long getUsedSpace() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getUsedSpace()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getUsedSpace(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMounted()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getUsedSpace(): The media is not mounted.");
            throw new MediaDeviceException("cannot determine used space on unmounted device");
        }
        long usedSpace = 1000L * this.mediaProperties.getUsedSpace();
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getUsedSpace(): returns " + usedSpace);
        return usedSpace;
    }

    public long getAvailableSpace() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getAvailableSpace()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getAvailableSpace(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMounted()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getAvailableSpace(): The media is not mounted.");
            throw new MediaDeviceException("cannot determine available space on unmounted device");
        }
        long availableSpace = 1000L * this.mediaProperties.getAvailableSpace();
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getAvailableSpace(): returns " + availableSpace);
        return availableSpace;
    }

    public boolean isMounted() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isMounted()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isMounted(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isMounted(): returns " + this.isMounted);
        return this.isMounted;
    }

    public File getMountPoint() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getMountPoint()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getMountPoint(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getMountPoint()");
        return new File(this.mediaDeviceProperties.getMountPoint());
    }

    public abstract void lockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException;

    public abstract void unLockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException;

    private void mount(boolean writable) throws MediaDeviceException, NoMediaPresentException, MediaWriteProtectedException, InvalidFileSystemException {
        int rc;
        int i;
        String[] mountCmd;
        Trace.trace(TRACE_MASKT, "-> MediaDevice.mount(writable = " + writable + ")");
        this.writeProtected = false;
        if (this.mediaDeviceIdentifier.getDeviceType().equals("DD")) {
            this.getLabel();
        }
        if (this instanceof Diskette) {
            try {
                mountCmd = new String[]{this.mediaServicesParameters.getParm(MOUNTSCRIPT), this.mediaDeviceProperties.getMountPoint(), this.mediaServicesParameters.getParm("media.temp.dir") + this.mediaDeviceProperties.getInternalName() + OUTPUT_FILE_SUFFIX, this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log"), "r"};
                i = 0;
                while (i < 5) {
                    Trace.trace(TRACE_MASKF, "mountCmd[" + i + "]: " + mountCmd[i]);
                    ++i;
                }
                rc = RootProcess.executeProgram(mountCmd);
                Trace.trace(TRACE_MASKF, "MediaDevice.mount(): rc = " + rc);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
                MediaDeviceException mdexc0 = new MediaDeviceException("we had an exception not covered by normal script return errors: " + exc.getMessage());
                new FrameworkLog(MediaServicesErrorIds._logInfo, 619, mdexc0).log();
                throw mdexc0;
            }
            switch (rc) {
                case 0: {
                    this.isMounted = true;
                    try {
                        if (this.getFileSystemType() == 1) {
                            this.mountWithUid = true;
                            break;
                        }
                        this.mountWithUid = false;
                    }
                    catch (Exception exc) {}
                    break;
                }
                case 3: {
                    this.isMounted = true;
                    this.writeProtected = true;
                    try {
                        if (this.getFileSystemType() == 1) {
                            this.mountWithUid = true;
                            break;
                        }
                        this.mountWithUid = false;
                    }
                    catch (Exception exc) {}
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    this.isMounted = false;
                    MediaDeviceException mdexc1 = new MediaDeviceException(MOUNT_SCRIPT_MESSAGES[rc]);
                    Trace.trace(TRACE_MASKF, mdexc1);
                    new FrameworkLog(MediaServicesErrorIds._logInfo, 619, mdexc1).log();
                    throw mdexc1;
                }
                case 5: {
                    this.isMounted = false;
                    throw new NoMediaPresentException(MOUNT_SCRIPT_MESSAGES[rc]);
                }
                case 6: {
                    this.isMounted = false;
                    Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[rc]);
                    throw new InvalidFileSystemException(MOUNT_SCRIPT_MESSAGES[rc]);
                }
                case 7: {
                    this.isMounted = false;
                    throw new MediaWriteProtectedException(MOUNT_SCRIPT_MESSAGES[rc]);
                }
                default: {
                    this.isMounted = false;
                    MediaDeviceException mdexc2 = new MediaDeviceException(MOUNT_SCRIPT_MESSAGES[1]);
                    Trace.trace(TRACE_MASKF, mdexc2);
                    new FrameworkLog(MediaServicesErrorIds._logInfo, 619, mdexc2).log();
                    throw mdexc2;
                }
            }
            try {
                this.unmount();
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        this.writeProtected = false;
        try {
            mountCmd = new String[8];
            mountCmd[0] = this.mediaServicesParameters.getParm(MOUNTSCRIPT);
            mountCmd[1] = this.mediaDeviceProperties.getMountPoint();
            mountCmd[2] = this.mediaServicesParameters.getParm("media.temp.dir") + this.mediaDeviceProperties.getInternalName() + OUTPUT_FILE_SUFFIX;
            mountCmd[3] = this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log");
            mountCmd[4] = writable ? "w" : "r";
            if (this.mountWithUid) {
                mountCmd[5] = "-o";
                mountCmd[6] = "uid=" + this.getUser();
            } else {
                mountCmd[5] = " ";
                mountCmd[6] = " ";
            }
            mountCmd[7] = this.getUser();
            i = 0;
            while (i < 8) {
                Trace.trace(TRACE_MASKF, "mountCmd[" + i + "]: " + mountCmd[i]);
                ++i;
            }
            rc = RootProcess.executeProgram(mountCmd);
            Trace.trace(TRACE_MASKF, "MediaDevice.mount(): rc = " + rc);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            MediaDeviceException mdexc3 = new MediaDeviceException("we had an exception not covered by normal script return errors: " + exc.getMessage());
            new FrameworkLog(MediaServicesErrorIds._logInfo, 619, mdexc3).log();
            throw mdexc3;
        }
        switch (rc) {
            case 0: {
                this.isMounted = true;
                break;
            }
            case 3: {
                this.isMounted = true;
                this.writeProtected = true;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                this.isMounted = false;
                MediaDeviceException mdexc4 = new MediaDeviceException(MOUNT_SCRIPT_MESSAGES[rc]);
                Trace.trace(TRACE_MASKF, mdexc4);
                new FrameworkLog(MediaServicesErrorIds._logInfo, 619, mdexc4).log();
                throw mdexc4;
            }
            case 5: {
                this.isMounted = false;
                throw new NoMediaPresentException(MOUNT_SCRIPT_MESSAGES[rc]);
            }
            case 6: {
                this.isMounted = false;
                Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[rc]);
                throw new InvalidFileSystemException(MOUNT_SCRIPT_MESSAGES[rc]);
            }
            case 7: {
                this.isMounted = false;
                throw new MediaWriteProtectedException(MOUNT_SCRIPT_MESSAGES[rc]);
            }
            default: {
                this.isMounted = false;
                MediaDeviceException mdexc5 = new MediaDeviceException(MOUNT_SCRIPT_MESSAGES[1]);
                Trace.trace(TRACE_MASKF, mdexc5);
                new FrameworkLog(MediaServicesErrorIds._logInfo, 619, mdexc5).log();
                throw mdexc5;
            }
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.mount()");
    }

    public void mountReadOnly() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, InvalidFileSystemException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.mountReadOnly()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.mountReadOnly(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        this.mount(false);
        Trace.trace(TRACE_MASKT, "<- MediaDevice.mountReadOnly()");
    }

    public void mountReadWrite() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, MediaWriteProtectedException, InvalidFileSystemException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.mountReadWrite()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (this.mediaDeviceIdentifier.getDeviceType().equals("CD")) {
            throw new MediaWriteProtectedException("CD-ROM drive, cannot mount in read-write mode");
        }
        if (this.mediaDeviceIdentifier.getDeviceType().equals("DV") && this.isDvdWriteProtected()) {
            throw new MediaWriteProtectedException("DVD-RAM cartridge is write protected");
        }
        this.mount(true);
        Trace.trace(TRACE_MASKT, "<- MediaDevice.mountReadWrite()");
    }

    boolean isDvdWriteProtected() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, MediaWriteProtectedException, InvalidFileSystemException {
        boolean readOnly;
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isDvdWriteProtected()");
        this.mount(true);
        try {
            FileWriter testFile = new FileWriter(this.getMountPoint().getAbsolutePath() + "/" + DVD_WRITE_CHECK_FILE);
            testFile.write(DVD_WRITE_TEST_STRING);
            testFile.close();
        }
        catch (IOException ioexc) {
            // empty catch block
        }
        this.unmount();
        this.mount(true);
        File finiTest = new File(this.getMountPoint().getAbsolutePath() + "/" + DVD_WRITE_CHECK_FILE);
        if (!finiTest.exists()) {
            readOnly = true;
        } else {
            readOnly = false;
            finiTest.delete();
        }
        this.unmount();
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isDvdWriteProtected(): returns " + readOnly);
        return readOnly;
    }

    public void unmount() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.unmount()");
        Trace.trace(TRACE_MASKD, "MediaDevice.unmount(): Performing garbage collection.");
        System.runFinalization();
        System.gc();
        Trace.trace(TRACE_MASKD, "MediaDevice.unmount(): Finished garbage collection.");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMounted) {
            Trace.trace(TRACE_MASKT, "<- MediaDevice.unmount()");
            return;
        }
        try {
            String[] unmountCmd = new String[]{this.mediaServicesParameters.getParm(UNMOUNTSCRIPT), this.mediaDeviceProperties.getMountPoint(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace(TRACE_MASKF, "MediaDevice.unmount(): unmountCmd[0] = " + unmountCmd[0]);
            Trace.trace(TRACE_MASKF, "MediaDevice.unmount(): unmountCmd[1] = " + unmountCmd[1]);
            Trace.trace(TRACE_MASKF, "MediaDevice.unmount(): unmountCmd[2] = " + unmountCmd[2]);
            int rc = RootProcess.executeProgram(unmountCmd);
            Trace.trace(TRACE_MASKF, "MediaDevice.unmount(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("the unmount operation failed, device may be in use");
            }
            this.isMounted = false;
        }
        catch (Exception exc) {
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            Trace.trace(TRACE_MASKF, mdexc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 620, mdexc).log();
            throw mdexc;
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.unmount()");
    }

    public synchronized void unlock() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.unlock()");
        if (this.isLockValid()) {
            try {
                if (this.isMounted()) {
                    this.unmount();
                }
                Trace.trace(TRACE_MASKF, "MediaDevice.unlock(): Unlocking the " + this.mediaDeviceIdentifier.getInternalDeviceName() + " that is currently locked by " + this.mediaDeviceIdentifier.getCurrentLockOwner() + ".");
                this.mediaDeviceIdentifier.unlock();
                this.mediaDeviceProperties = null;
                Trace.trace(TRACE_MASKF, "MediaDevice.unlock(): The media device was successfully unlocked.");
            }
            catch (Exception exc) {
                this.mediaDeviceIdentifier.unlock();
                this.mediaDeviceProperties = null;
                MediaDeviceLockException mdlexc = new MediaDeviceLockException(exc);
                Trace.trace(TRACE_MASKF, mdlexc);
                new FrameworkLog(MediaServicesErrorIds._logInfo, 621, mdlexc).log();
                throw mdlexc;
            }
        } else {
            Trace.trace(TRACE_MASKF, "MediaDevice.unlock(): The caller does not have a lock on the device and cannot unlock it.");
            return;
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.unlock()");
    }

    protected void finalize() {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.finalize()");
        try {
            this.unlock();
        }
        catch (Exception exc) {
            this.mediaDeviceIdentifier.unlock();
            this.mediaDeviceProperties = null;
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.finalize()");
    }

    private String getUser() throws MediaDeviceException {
        String user;
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getUser()");
        try {
            Process whoProcess = Runtime.getRuntime().exec(WHO_AM_I_COMMAND);
            BufferedReader in = new BufferedReader(new InputStreamReader(whoProcess.getInputStream()));
            user = in.readLine();
            Trace.trace(TRACE_MASKF, "MediaDevice.getUser(): user = " + user);
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            throw new MediaDeviceException(ioexc);
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getUser(): returns " + user);
        return user;
    }
}

